#rem
'CleverLoad Calibration Program

'HARDWARE
'SmartLoad main and display boards
'All I2C buss devices must work before using this program.

'WHAT IT DOES
'  1) Sets the ISL12026 onboard real time clock and trims the Xtal oscillator
'		Set clock date & time
'		Trims the clock's crystal oscillator freq by 
'			Setting the Analog Trimming Register (ATR)
'			Setting the Digital Trimming Register (DTR)
'  2) Enables Calibration of the power meter with external sources whose level has 
'       a known accuracy to within 0.1dBm
'		1)0.0dBm reference level 
'           2)High power scaling factor (signal between 30.0 and 43.0dBm)
'		3)8x gain scaling factor (6.00dBm ref and -3dBr delta)
'  3) Update the EEPROM calibration data
'	  Review and record clock ATR,DTR,Power meter 0dBm reference reading,
'       high power Sf & 8x gain SfP scaling factors. This data is automatically stored
'	  in the EEPROM during calibartion, but should be recorded separately so that if
'       the EEPROM data is ever lost it can be reloaded without recalibrating the meter..
'  4) Writes ISL12026 EEPROM data.- a combination of defaults and current data from memory:
'	  Housekeeping items (16 bytes)
'		Turn off time interval in minutes 0-59 above 170=disable (one byte)
'		Backlight level value (three bytes)
'		Measurement mode to use after start-up -fs - autoscale -peak - datalog
'		Attenuator pad off/on (one byte) & value xx.xdB (3bytes)2.0 to 40.1 valid
'		Temperaute alarm threshold (one byte) 35deg.C default
'		0dBm raw A-D reading (one byte)
'		High Power scaling factor (one byte) 800 default
'		8x scaling factor word (two bytes) 1000 default
'		dBm_W flag to toggle display between dBm=0 and Watts=1
'       dBm to Watts antilog table (32 bytes)
'	  CGRAM special characters for bargraph and battery (64 bytes)
'	  Backlight data brightness level & current draw (54 bytes)
'	  		
'DOWNLOAD
'There is no reset function on the 20X2 & this unit employs a soft power switch
'To download if the unit is off skip steps 1 and 2
'1) Turn unit's power supply off, wait a few seconds for all caps to discharge
'2) Turn unit's power supply back on, the unit must remain off. 
'3) Start the download process on the PC, 
'4) When the 'Connecting to hardware...' window appears push S3, the button below
'   the display and keep it held down until programming is complete.  
#EndREM

variables:'used by Smartload not all variables will be used by this Cal program 
   symbol intvcc=c.1		'switched internal V+ high=off
  symbol gainvcc=b.2		'switched internal for 8x gain block high=off
  symbol bklite=c.5		'display backlight high=off
  symbol wpEEPROM=b.4		'Write Protect 24LC256 lo=write enable
  symbol shdn=c.2			'regulator shutdown low=shutdown
  symbol fan=c.4			'fan switch high=off
  symbol sw1=pinb.6		'menu switch 1 to 20X2 leg 4 -top button
  symbol sw2=pinc.0		'menu switch 2 to 20X2 leg 10 -middle button
  symbol sw3=pinc.6		'menu switch 3 to 20X2 leg 1 -lower button
  symbol BitLevel=b0		'generic variable for all bit mode storage
  	'bit 0 controls exit from Utilities menu for many submenu items
  	'bit 1 controls exit from chk for LoRF to goto Utilities menu
  symbol MainMenuItem=b1	'keeps track of main menu current location
  symbol SubMenuItem=b2		'keeps track of utility menu current location
  symbol var1=b3			'generic variable leased by subroutines
  symbol var2=b4			'generic variable leased by subroutines
  symbol var3=b5			'used across many routines to flag negative no.
  symbol unit=b6			'used to parse numbers for display units
  symbol ten=b7			'used to parse numbers for display tens
  symbol hundred=b8		'used to parse numbers for display hundreds
  symbol thousand=b9		'used to parse numbers for display thousands
  symbol TurnOffInterval=b10	'valu sets unit turn off time if no switches pushed
  symbol OffTime=b11		'contains updated turnoff time if any switch pushed
  symbol PowerSymbol=b12	'shows power source battery level symbol
  symbol range=b13		'used in bargraph display
  symbol rangelo=w7		'used in bargraph display b14 & b15
  symbol rangehi=w8		'used in bargraph display b15 & b16
  symbol var4=b18			'used in dBmtoWatts conversion
  symbol var5=b19			'used in dBmtoWatts conversion
  'b20 not used
  symbol varw10=w10		'Word generic variable leased by subroutines
  symbol varw11=w11		'Word generic variable leased by subroutines
  symbol varw12=w12		'Word generic variable leased by subroutines
  symbol varw13=w13		'Word generic variable leased by subroutines
  symbol dBm=w14			'curreent value of power reading in dBm
  'b30-b37 used for ISL12026 RTC Clock Control Register for time date read & set
  symbol Watts=w19		'current value of power reading in Watts b38 & b39
  'b39 not used
'housekeeping & Cal
  symbol dBm_W=b41		'0=display dBm, 1=display Watts
  symbol ATR=b42			'ISL12026 RTC Analog Trim Register
  symbol DTR=b43			'ISL12026 RTC Analog Trim Register
  symbol MeasMode=b44		'Meas mode
  'measurement mode 0=full scale 1=Autorange 2=Peaking 3=Datalog
  symbol TempThresh=b45		'Temperature Alarm thrshold 
  symbol ZerodBm=b46		'0.0dBm raw A-D value  
  symbol AttenState=b47		'Attenuator state 1=on 0=off
  symbol AttenValu=w24		'Attenuator value in fromat xx.xdB b48,b49
  symbol Sf=w25			'scale factor for high power tracking b51 50
  symbol SfP=w26			'scale factor for Peaking mode 8xGain b52 53
  symbol BkLiteLevel=w27	'sets display backlight LED brightness b54 55
  
Main:
  high shdn,fan,wpEEPROM,intvcc,gainvcc 'keep unit powered and configure outputs
  pwmout bklite,249,900		'set backlight on  low, consumes 2ma.
  TurnOffInterval=255 		'sets interval >170 so is off
  hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display
  hi2cout ($00,$39,$14,$70,$5e,$6b,$0c,$06,$01) 'initialize display
  gosub SplashScreen
  pause 1500'give some time to read splash screen & settle pwr supply for clock
 'gosub WriteSpecialChars     'loads display CGRAM with special characters
  let adcsetup=%0100000010101010'removes digital input from ADC converters used
  pokesfr $22,4	'for C.0 fw - issue after adcsetup to fix V+ reference bug
  'Load in existing calibration and Housekeeping registers from ISL12026 EEPROM
  gosub ReadCCR
  if b35<10 then'Clock data is corrupt year is <2010 so...
    gosub WriteCCR 'kick the clock to start it, won't be right time but
    hi2cout $0035,(20)'off timer will work...wirte year 2020
  endif
  hi2cin $0012,(ATR,DTR)'load in current values for CCR ATR & DTR
  'TurnOffInt,BkLiteLevel,MeasMode,AttenState,AttenValu,ZerodBm,Sf,SfP from EEPROM
  hi2cin [$ae],$0000,(TurnOffInterval,b54,b55,MeasMode,AttenState,b48,b49,TempThresh,ZerodBm,b50,b51,b52,b53,dBm_W)
  gosub MainMenu
goto Main

MainMenu: '0=SetClock 1=Cal Clock 2=Cal Power 3=CalUpdates 4=EEPROM Defaults 5=PwrOff
  'displays main title on the display line 1 and menu itmes on line 2
  'pressing S1 increments menu choice, S2 decrements menu choice, S3 selects
  gosub ClearDisplay
  MainMenuItem=0	'keeps track of menu items init this variable to 0
  MainMenuInnerMenuLoop:
  gosub MainMenuLine1Title 'write main title to display...used many times
  if MainMenuItem=0 then 'displys Up or Dn opposite S1 and S2
    gosub DisplayDn 'at top of menu items so remove Up.
  else
    gosub DisplayUpDn
  endif 
  on MainMenuItem gosub MenuClkSet,MenuClkCal,MenuRFPwrCal,MenuEEPROMCalDataUpdate,MenuWriteEEPROMDefaults,MenuPwrOff
  pause 600 'wait a bit so display can be viewed
  do while sw1=0 and sw2=0 and sw3=0 'stay put until a switch is pushed
   'loop unitl a switch is pushed
  loop 'until a switch is pushed
    if sw3=1 then
      pause 600 'give a bit of time to get finger off of the select button
      on MainMenuItem gosub ClkSet,ClkCal,RFPwrCal,EEPROMCalDataUpdate,WriteEEPROMData,PwrOff
      pause 300 'returned from subroutine` or button held down so wait a bit
    else if sw1=1 and MainMenuItem >0 then
      dec MainMenuItem
    else if sw2=1 and MainMenuItem<5 then 'max count is menu items less 1 
      inc MainMenuItem
    endif
  goto MainMenuInnerMenuLoop
  return

MenuClkSet: 'sets ISL2026 RTC time and date
  hi2cout ($80,$c3,$40,"  Set Clock  ")
return

MenuClkCal: 'Calibrates ISL12026 clock frequency ATR and DTR registers 
  hi2cout ($80,$c3,$40,"Clk Cal Freq ")
return
MenuRFPwrCal:'Calibrates RF power levels at 0dBm,30dBm and 8x gain 0 &-3.00dBm
  hi2cout ($80,$c3,$40,"RF Power Cal ")
return
MenuEEPROMCalDataUpdate:'Displays cal regs RTC & power for user updates from defaults
  hi2cout ($80,$c3,$40,"Show Cal Data")
return
MenuWriteEEPROMDefaults:'Writes cal & user info to ISL2026 EEPROM
  hi2cout ($80,$c3,$40,"Write EEPROM ")
return
MenuPwrOff:
  hi2cout ($80,$c0,$40,"   Turn Unit Off")'last menu item so overwrite Dn
return
MainMenuLine1Title:
   hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display
   hi2cout ($80,$83,$40,"SL Utilities ")'write MainMenu header
return 

 
ClkSet:'sets all clock functions then displays dd/mm/yy line 1 and hh:mm line2
'REM HH:MM:SS stored in BCD, DD/MM/YY stored in binary
'Set minutes to next minute, then wait for zero seconds & press s3. 
'All 8 register entries are loaded into the chip with seconds set to zero
'Leases
'b30-b37 - clock registers
'var1  date time register manipulation
'var2  trap for bcd vs bin counter
'var3  max limit for clock calender entries
'var4  flag 1=bin 0=bcd

   gosub ClearDisplay
   hi2cout($80,$c0,$40,$7f,"Set") 'wirte line 2 point to sw2 to set
   do while sw1=0 and sw2=0 and sw3=0 'stay put until a switch is pushed
     gosub ReadCCR: 'read clock registers into b30-b37
     gosub DisplayHMS
     gosub DisplayDMY
   loop 'until a switch is pushed
    if sw3=1 or sw1=1 then 
      goto EndClkSet 
    endif
      hi2cout ($80,$01) 'clear display
      pause 1 
      gosub DisplayUpDn
      var4=1
      gosub SetYear
      gosub SetMonth
      gosub SetDay
      var4=0
      gosub SetHour
      gosub SetMin
      b30=0 ' set seconds to zero
      gosub WriteCCR
      hi2cout $0030,(b30,b31,b32,b33,b34,b35,b36,b37)
      gosub MainMenuLine1Title
  EndClkSet:
  inc MainMenuItem 
return

ReadCCR:
  hi2csetup i2cmaster,$de,i2cfast_8,i2cword 'Clock Register
  hi2cin $0030,(b30,b31,b32,b33,b34,b35,b36,b37)
return


DisplayHMS: 'REM HH:mm:ss converted from BCD displayed at end of line 1.
    var1=b30 'get seconds
    gosub BCD2ascii:
    hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display
    hi2cout ($80,$8d,$40,":",ten,unit)'wirte seconds
    var1=b31 'get minutes
    gosub BCD2ascii
    hi2cout($80,$8a,$40,":",ten,unit) 'write minutes
    var1=b32 'get hours
    var1=var1 & %01111111 'get rid of 24hr 'Mil' bit
    gosub BCD2ascii
    hi2cout($80,$88,$40,ten,unit)'write hours to display
 return
 
BCD2ascii: 'conversion takes 12 lines of code so subroutine is smaller 
 bcdtoascii var1,ten,unit 'when used just a couple times.
return
BIN2ascii:
 bintoascii var1,hundred,ten,unit
return

DisplayDMY: 'DD/MM/YY converted from bin displayed at end of line2
    var1=b33 'days
    gosub BIN2ascii
    hi2cout($80,$c6,$40,ten,unit)
    var1=b34 'months
    gosub BIN2ascii
    hi2cout($80,$c8,$40,"/",ten,unit) '
    var1=b35 'years
    gosub BIN2ascii
    hi2cout ($80,$cb,$40,"/20",ten,unit)
 return

SetYear:
   var1=b35 'current year
   var3=30 'max year set to 30
   hi2cout ($80,$85,$40,"Set Year ")
   gosub IncDec 'change year
   b35=var1 'returned year stored in register
return

SetMonth:
   var1=b34
   var3=12
   hi2cout ($80,$85,$40,"Set Month")
   gosub IncDec
   b34=var1
return

SetDay:
   var1=b33
   var3=31
   hi2cout ($80,$85,$40,"Set Day  ")
   gosub IncDec
   b33=var1
return

SetHour:
   var1=b32
   var1=var1 & %01111111 'get rid of 24hr 'Mil' bit
   var3=$23
   hi2cout ($80,$85,$40,"Set Hour ")
   gosub IncDec
   var1=var1 or %10000000 'add back in 24hr 'Mil' bit
   b32=var1
return

SetMin:
   var1=b31
   var3=$59 'set for 
   hi2cout ($80,$85,$40,"Set Min  ")
   gosub IncDec
   b31=var1
return

IncDec:'inc or dec clock vaules in bcd for time and bin for dates
'REM this Inc/Dec counter can be used in either bcd or bin; Var2=$ff bin,else bcd
'REM Var2 set to $FF for bin, and looks for %1001 inc or 0 dec to bypass $a-$f
   pause 300 'wait a bit while to make sure menu doesn't go by too fast
   if var4=0 then 'bcd or bin flag
     gosub BCD2ascii 'translates number to ascii
     else
     gosub BIN2ascii 'tranlates day month year to ascii
   endif
   hi2cout ($80,$c8,$40,ten,unit)'display current choice. 
   do while sw1=0 and sw2=0 and sw3=0 'wait for a switch to be depressed
    'loop unitl a switch is pushed
   loop
    if var4=1 then 'if setting days months or years bypass BCD counter
      var2=$FF
      else
      var2=var1 & %00001111 'set trap for BCD counter
    endif
    if sw3=1 then
      goto EndIncDec
    else if sw1=1 and var1 <= var3 then 'increment 
      if var2=09 then	'if bcd 1001 then add 7 to get bcd 10000 bin skip a-f
        var1=var1+7
        else
        inc var1
      endif
    else if sw2=1 and var1 >= 0 then 'decrement 
      if var2=0 then 'if bcd xxxx0000 then subtract 7 to get bcd xxxy1001
        var1=var1-7
        else
        dec var1
      endif
    endif
     if var1>var3 then 'if > max then loop back to zero.
      var1=0
      endif
  goto IncDec
  EndIncDec:
return  


ClkCal:'3 menu items 1)Trim ATR 2)Trim DTR 3)Return to main menu
'Measure clock internal oscillator frequency 32768Hz at pin3, TP5 on main board
'with a counter that is capable of resolving down to milihertz (0.001Hz). 
'To adjust select ATR and change the capacitance value until the frequency is 
'as close as possible (rem to use a counter capable of showing miliHertz)
'Exit ATR then run DTR and select digital frequency trim from +/- 30ppm.
'to achieve a frequency of 32768.000Hz..

'Leases
'var2 controls exit
  SubMenuItem=0 'set initial submenu item value
  var2=0 'variable used to control exit
  gosub ThirtyTwokHz
  InnerTrimFreq:
    if var2=255 then 'check for exit
      goto ExitTrimFreq
    else if SubMenuItem=0 then
      gosub DisplayDn 'at top of menu items so remove up.
    else
      gosub DisplayUpDn
  endif 
  on SubMenuItem gosub MenuSaveATR,MenuSaveDTR,MenuReturntoMainMenu
  pause 600 'wait a bit so display can be viewed if sw1 or 2 is held down  
  do while sw1=0 and sw2=0 and sw3=0 'stay put until a switch is pushed
    'loop unitl a switch is pushed
  loop 'until a switch is pushed
  if sw3=1 then
      pause 600 'give a bit of time to get finger off of the select button
      on SubMenuItem gosub SaveATR,SaveDTR,ReturnToMainMenu
    else if sw1=1 and SubMenuItem >0 then
      dec SubMenuItem
    else if sw2=1 and SubMenuItem <2 then 'max count is menu items less 1 
      inc SubMenuItem
  endif
  goto InnerTrimFreq
 ExitTrimFreq:
 inc MainMenuItem
 gosub MainMenuLine1Title:
return

MenuSaveATR:
  hi2cout ($80,$c3,$40,"  Analog Trim")
return
MenuSaveDTR:
  hi2cout ($80,$c3,$40," Digital Trim")
return 
MenuReturnToMainMenu:
  hi2cout ($80,$c0,$40," Bk to Main Menu")'set Fout disabled, alarm enabled
return 

ThirtyTwokHz:'sets ISL12026 Alarm output pin 3 to 32768Hz square wave
  gosub WriteCCR:
  hi2cout $0011,($08)'set clock alarm output to 32kHz
return

SaveATR: 'Sets Analog Trim Register Changes Xtal cap from 20.25 to 9.5pf ctr 12.5pf
'Leases
'b30-b35 calculate load capacitance
'var3 cap lsb value .0 or .5
'var4 and var5 upper and lower loop limits for pos & negative reg2 values.
gosub ClearDisplay
  hi2cout ($80,$83,$40,"Trim Xtal Cap")'write function header to display
  gosub DisplayUpDn 
  goto JumpIntoATR
  InnerATR:
  'Trim cap value default is 12.5pf at ATR=0. Cx increases in .25pf steps as ATR
  'increases from 1=12.75pf to 31=20.25pf. It then changes at 32 to 4.5pf and
  'increases again as ATR increases from 32=4.5pf to 63=12.25pf
  if ATR<=31 then 'Cx is 12.75pf to 20.25pf as ATR changes from 1 to 31
    var4=31 'maximum limit for inc dec while in this range
    var5=0  'minimum limit for inc dec while in this range
    else if ATR>=32 then'Cx is 4.5pf to 12.25pf as ATR changes from 32 to 63
    var4=63 'maximum limit for inc dec while in this range
    var5=32 'minimum limit for inc dec while in this range
  endif
   do while sw1=0 and sw2=0 and sw3=0 'stay put until a switch is pushed
    'loop unitl a switch is pushed
   loop 'until a switch is pushed
    if sw3=1 then
      goto ExitATR
    elseif sw1=1 and ATR=31 then'at max Cx and asking for more so bypass inc dec 
      goto InnerATR 'simply loop and remain here at max Cx value while condition is true
    elseif sw2=1 and ATR=32 then'at min Cx and asking for less so bypass inc dec
      goto InnerATR'simply loop and remain here at min Cx value while condition is true
    elseif sw1=1 and ATR=63 then'at 12.25pf so next inc step must be 12.5pf which is Cx=0 
      ATR=0
    elseif sw2=1 and ATR=0 then'at 12.5pf so next dec step must be 12.25pf which is Cx=63
      ATR=63
    else if sw1=1 and ATR <= var4 then
      inc ATR
    else if sw2=1 and ATR >= var5 then
      dec ATR
    endif
    gosub WriteCCR 'prepare to write CCR with new cap value
    hi2cout $0012,(ATR) 'write new cap trim value to CCR EEPROM register
    pause 25 'CCR EEPROM write takes 20ms min before I2C buss is released 
  JumpIntoATR:
  hi2csetup i2cmaster,$de,i2cfast_8,i2cword 'Configure Clock Control Register
  hi2cin $0012,(ATR)'read in ATR
  gosub CapacitorCalc 'calculate load cap value
  pause 300 'give some time for display to be read if sw1 or 2 is held
  goto InnerATR
  ExitATR:
  inc SubMenuItem 'go to next TrimFreq menu item
return

CapacitorCalc:'Calculates ATR Trim cap in pF and displays it
  b30= ATR xor %00100000 &%00100000/4*10
  b31= ATR & %00010000/4*10
  b32= ATR & %00001000/4*10
  b33= ATR & %00000100/4*10
  b34= ATR & %00000010*10/4
  b35= ATR & %00000001*10/4
  var1=b30+b31+b32+b33+b34+b35+45
  if b35=0 then
    var3="0" else var3="5"'var3 is cap LSB value 0.0 or 0.5pf
  endif
  gosub Bin2ascii 'convert var1, load cap to ASCII for display
  hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display
  hi2cout ($80,$c4,$40,"ATR=",hundred,ten,".",unit,var3,"pf")'write cap to display
return

SaveDTR: 'Sets Digital Trim Register
'The DTR resgister is another one that swings +/- of zero using a three bit 
'binary number.  Unfortunately the PPM doesn't associate
'with the binary number count. 10ppm is 010, 20ppm is 001,
'So the easiest way to handle this is with a series of writes to the dsiplay
'that show the PPM count associated with the register value with upper and 
'lower limits at 30.
'Leases
'var4 and var5 upper and lower loop limits for pos & negative reg2 values.
  gosub ClearDisplay 
  hi2cout ($80,$83,$40,"Dig Freq Trim")'write function header to display
  hi2cout ($80,$c0,$40,$7f,"Chg")
  DTR=0 
  goto JumpIntoDTR
  InnerDTR:
   do while sw2=0 and sw3=0 'stay put until a switch is pushed
    'loop unitl a switch is pushed
   loop 'until a switch is pushed
    if sw3=1 then
      goto ExitDTR
    else if sw2=1 then
      inc DTR
    endif
    if DTR=4 then '4 is also zero so skip it
     inc DTR
    else if DTR=8 then 
      DTR=0 
    endif
    gosub WriteCCR 'prepare to write CCR with new Digital Trim value
    hi2cout $0013,(DTR) 'write new cap trim value to ccr
    pause 25 'EEPROM wirte busies out ISL12026 for 20ms or so
  JumpIntoDTR:
  hi2csetup i2cmaster,$de,i2cfast_8,i2cword 'Configure Clock Control Register
  hi2cin $0013,(DTR)'read in DTR
  hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display
  gosub DisplayDTR       
  pause 300 'give some time for display to be read if sw1 or 2 is held
  goto InnerDTR
  ExitDTR:
  inc SubMenuItem 'go to next TrimFreq menu item
return

DisplayDTR:
  hi2cout ($80,$c4,$40,"DTR=   ppm ")
  if DTR=0 then
      hi2cout ($80,$c8,$40,"+00")'write DTR vlaue to display
    else if DTR=1 then
      hi2cout ($80,$c8,$40,"+20")'write DTR vlaue to display
    else if DTR=2 then
      hi2cout ($80,$c8,$40,"+10")'write DTR vlaue to display
    else if DTR=3 then
      hi2cout ($80,$c8,$40,"+30")'write DTR vlaue to display
    else if DTR=5 then
      hi2cout ($80,$c8,$40,"-20")'write DTR vlaue to display
    else if DTR=6 then
      hi2cout ($80,$c8,$40,"-10")'write DTR vlaue to display
    else if DTR=7 then
      hi2cout ($80,$c8,$40,"-30")'write DTR vlaue to display
  endif 
return

ReturnToMainMenu:'used to return to main from Clock submenus
  'pause 300 'allow time to get finger off button
  gosub WriteCCR:
  hi2cout $0011,($00)'Set Fout to disable 32kHz and enable alarm
  var2=255 'set return flag to exit Freq Trim Submenu
return 

RFPwrCal:'3 menu items 0dBm Cal, Peaking Gain Cal, High Power Cal
'Create a zero dBm reference value
'	Apply 0.0dBm.  Actual power must be accurate to 0.1dBm. Save reading
'Create a high power scaling factor (Sf) to account for detector monoticity & other errors
'	Apply and RF signal between 30-40dBm Actual power must be known to 0.1dBm. Save reading.
'	Then increment or decrement the display to show actual input power reading xx.xdBm
'	Press S3 to automatically create & save a scaling factor based on the actual power value entered.
'Create a peaking gain scaling factor (SfP)
'	Enter 8x gain mode.  Set input level to anything between +6 to +10dBm
'	Set reading to zero 0.00dB 
'	Change input power level by -3.00dB. Press S3 to automatically calculate and save SfP
'Leases
'var2 controls exit
  SubMenuItem=0 'set initial submenu item value
  var2=0 'variable used to control exit
  low intvcc,gainvcc 'turn on power to detector & 8x gain block
  InnerRFPwrCal:
    gosub MainMenuLine1Title
    if var2=255 then 'flag set by BackToMainMenu to exit
      goto ExitRFPwrCal
    elseif SubMenuItem=0 then
      gosub DisplayDn 'at top of menu items so remove up.
    else
      gosub DisplayUpDn
    endif 
  on SubMenuItem gosub Menu0dBmCal,MenuPeakingModeCal,MenuHighPowerCal,MenuBacktoMainMenu
  pause 600 'wait a bit so display can be viewed if sw1 or 2 is held down  
  do while sw1=0 and sw2=0 and sw3=0 'stay put until a switch is pushed
    'loop unitl a switch is pushed
  loop 'until a switch is pushed
  if sw3=1 then
      pause 600 'give a bit of time to get finger off of the select button
      on SubMenuItem gosub ZerodBmCal,PeakingModeCal,HighPowerCal,BackToMainMenu
    elseif sw1=1 and SubMenuItem >0 then
      dec SubMenuItem
    elseif sw2=1 and SubMenuItem <3 then 'max count is menu items less 1 
      inc SubMenuItem
  endif
  goto InnerRFPwrCal
 ExitRFPwrCal:
 inc MainMenuItem
 gosub MainMenuLine1Title:'re display main menu title line.
 high intvcc,gainvcc 'turn off power to detector & 8x gain block
return

Menu0dBmCal:
  hi2cout ($80,$c3,$40,"0dBm Cal     ")
return
MenuHighPowerCal:
  hi2cout ($80,$c3,$40,"Hi Power Cal ")
return 
MenuPeakingModeCal:
  hi2cout ($80,$c3,$40,"Peaking Cal  ")
return
MenuBacktoMainMenu:
  hi2cout ($80,$c0,$40," Bk to Main Menu")
return
  
ZerodBmCal:'Apply 0.0dBm & wait for reading to stabalize then save
'Leases
'varw11 low RF threshold 50 (<-10dBm) for normal 120 (<-6dBM)for find half rail
  gosub ClearDisplay 
  hi2cout ($80,$80,$40,$7f,"Apply 0.0dBm")
  pause 2000
  varw11=205 'LoRF threshold set to about -0.5dBm 
  do while sw1=0 and sw2=0 and sw3=0 'read the ADC unitl sw is pushed
    hi2cout ($80,$80,$40,$7f,"Apply 0.0dBm")
    hi2cout ($80,$c0,$40,"  ")
    pause 1000 'leave a bit of time to read the display
    gosub ChkForLoRF
    readadc10 5,varw10 'read 8362 out
  loop
    if sw1=1then 'save the 0dBM reading
      ZerodBm=b20 'lower byte of W10
      'save reading in ISL2026 Housekeeping EEPROM memory location $9
      gosub UnlockISL12016EEPROM'make sure the EEPROM is writable
      hi2cout [$ae],$0009,(ZerodBm) 'write EEPROM
      pause 25
      gosub LockISL12016EEPROM 'wirte protect the EEPROM
      gosub Decimal
      gosub ClearDisplay
      hi2cout ($80,$80,$40,"Ref Value Saved ")
      hi2cout ($80,$c3,$40,"0dBm=",hundred,ten,unit)
    else
      goto EndZerodBmCal
    endif
  do while sw3=0
    'loop unitl a switch is pushed
  loop
  EndZerodBmCal:
  inc SubMenuItem
return

HighPowerCal:'Apply 30.0 to 40.0dBm & wait for reading to settle.
'Calculates and stores a scaling factor accounting for AD8362 slope
'error from 0dBm (50mV/dB) and A-D error due primarily to Vref error.
'Scaling factor is typically 0.8. 
'AD8362 detector output is 50mV/dB or 500mV per dB decade.
'Measurement resolution is 4mV per bit (4.096 ref/1024 steps)=125steps/decade
'The -10 to +50 dBm range results in 750 steps.
'To scale this to 600 steps (0.1dB per step) multiply by 0.8

'Leases
'var2 low RF threshold 50 (<-10dBm) for normal 120 (<-6dBM)for find half rail
'varw10 power level entered by user
'varw11 net raw reading = high power reading-zerodBm reading & LoRf threshold
'varw12 intermediate value used to calculate Sf
'varw13 intermediate value used to calculate Sf
  varw11=530'LoRF threshold set to about 25dBm 
  gosub ClearDisplay
  do while sw1=0 and sw3=0 'read the ADC unitl sw is pushed
    hi2cout ($80,$80,$40,$7f,"Apply 30-40dBm")
    hi2cout ($80,$c0,$40,"  ")
    pause 1000
    gosub ChkForLoRF
    readadc10 5,varw10 'read 8362 out
  loop
    if sw1=1then 
    	  goto GetHiPowerUserInput
    	else
    	  goto EndHighPowerCal'get out of app before saving reading in EEPROM
    endif
   GetHiPowerUserInput: 
      'calculate net rf Raw A-D level change
       varw11=varw10'store high pwr reading in var11 
       varw11=varw11-ZerodBm'varw12 now stores netraw A-D reading
       'NOW GET THE ACUTAL POWER APPLIED TO THE UNIT FROM THE USER
       gosub ClearDisplay
       gosub DisplayUpDn 'add Up and Down to display
       hi2cout ($80,$83,$40,"Power Applied")
       hi2cout ($80,$ca,$40,"dBm")
       varw10=350 'seed power level at 35.0dBm
       pause 600'wait for user to get finger off button from power meas above.
       DisplayActualPower:
       gosub decimal'parses W10 for display
       hi2cout ($80,$c6,$40,hundred,ten,".",unit)
       pause 100 'provide a littel time to read display
       do while sw1=0 and sw2=0 and sw3=0
          'loop unitl a switch is pushed
       loop' just lay about until a switch is pushed
       if sw1=1 and w10<431 then 'increment if <=43.0dBm
           inc w10
         else if sw2=1 and w10>269 then 'decrement if >=26dBm
           dec w10
         else if sw3=1 then
         pause 600 'give a little time to get finger off the button 
         goto CalcSF
       endif
       goto DisplayActualPower
       calcSf:'calculation method detailed in prog example 
       varw12=varw10*10/varw11     'Divide to Generate a Scaling Factor.bas'
       varw13=varw10*10%varw11*100/varw11
       sf=varw12*100+varw13
       varw13=varw10*10%varw11*100%varw11*100/varw11
       if varw13>49 then 'round up sf if remainder is =>50
        inc sf
       endif
      'now save in ISL2026 Housekeeping section locations $a
       gosub UnlockISL12016EEPROM'make sure the EEPROM is writable
       hi2cout [$ae],$0009,(b50,b51) 'write EEPROM low byte of w14 (b28,b29)
       pause 25
       gosub LockISL12016EEPROM 'wirte protect the EEPROM
       gosub ClearDisplay
       varw10=Sf
       gosub decimal
       hi2cout ($80,$80,$40,"HiPower Sf Saved")
       hi2cout ($80,$c5,$40,"Sf=",thousand,hundred,ten,unit) 
       do while sw3=0'stay here until sw3 is pushed
         'loop unitl a switch is pushed
       loop
    EndHighPowerCal:
    inc SubMenuItem
return


PeakingModeCal:'Apply +7dBm, zero reading, change by +3.00dBm and save.
'Leases
'var1 keeps track of pot setting
'var2 low RF threshold 50 (<-10dBm) for normal 120 (<-6dBM)for find half rail
'var3 flag for negative sign for dbm/dbr routine
'varw10 word reading for display decimal conversion
'varw11 intermediate value for scaled numbers & LoRf threshold
'varw12 8x gain out
'varw13 reference for dBr readings
  var1=1 'pot setting to lowest tap but allow one decrement in the inner loop
  var2=0 'if 1 bypass auto zero
  var3=0 'flag for negative dBm reading
  gosub ClearDisplay
  varw11=295 'LoRF threshold set to about 6.2dBm
  do while sw1=0 and sw3=0
      hi2cout [$7c],($80,$80,$40,$7f,"Apply +7.00dBm ")
      hi2cout ($80,$c0,$40,"  ")
      pause 1000 'provide a little time to read the dsiplay
      gosub ChkForLoRf
  loop
  if sw1=0 then 
      goto StabilizeIntialEightxReading
    elseif sw3=1 then 
      goto EndEightxGainCal
    endif
  StabilizeIntialEightxReading:
  gosub FindHalfRail
  gosub ClearDisplay
  hi2cout [$7c],($80,$80,$40," Stabilizing... ")
  hi2cout($80,$c0,$40,"takes upto 30sec")
  StabilizeReading:'insures reading drift is minimal
  wait 5 'let circuit stabilize for a time
  varw10=varw12 'store previous loop reference value in varw10
  readadc10 7,varw12 'read 8xgain out value
  if varw10 <> varw12 then'reading must be the same for at least wait period 
  endif
  EndStabilizeReading:
  varw13=varw12 'word 13 is now the reference for delta readings
  gosub ClearDisplay
  varw11=325 'LoRF threshold set to about 9dBm
  do while sw1=0
     hi2cout [$7c],($80,$80,$40,$7f,"Apply +10.00dBm")
     hi2cout ($80,$c0,$40,"  ")
     pause 1000 'leave a little time to read the display
     gosub ChkForLoRf
  loop
  'now make sure the reading is stable
  StabilizeDeltaReading:
  readadc10 7,varw12 'read 8xgain out value
  hi2cout [$7c],($80,$80,$40," Stabilizing... ")
  wait 5 'let circuit stabilize for a time
  varw10=varw12 'store previous loop reference value in varw10
  readadc10 7,varw12 'read 8xgain out value
  if varw10 <> varw12 then'reading must be the same for at least wait period 
    goto StabilizeDeltaReading
  endif
  'now calculate scaling factor & store in ISL2026 housekeeping reg
  varw11=varw12-varw13'net change with +3dBm power step
  varw10=300
  calcSfP:'calculation method detailed in ScaleByAFctorTest.bas 
  varw12=varw10*10/varw11     'Divide to Generate a Scaling Factor.bas'
  varw13=varw10*10%varw11*100/varw11
  SfP=varw12*100+varw13
  varw13=varw10*10%varw11*100%varw11*100/varw11
  if varw13>49 then 'round up sf if remainder is =>50
     inc SfP
  endif
  'ideal scale factor should be 1.000, net change/300 (3.00dB*.01dB/bit)
  'calculation results in xxxx which is used as x.xxx when scaling 
  'now save SfPeak in ISL2026 Housekeeping section locations $b,$c lsbyte first
  gosub UnlockISL12016EEPROM'make sure the EEPROM is writable
  hi2cout [$ae],$000b,(b52,b53) 'write EEPROM with Sfp (b52 & b53)
       pause 25
       gosub LockISL12016EEPROM 'wirte protect the EEPROM
       gosub ClearDisplay
       varw10=SfP
       gosub decimal
       hi2cout ($80,$80,$40,"Peaking SF Saved")
       hi2cout ($80,$c4,$40,"SfP=",thousand,hundred,ten,unit) 
       do while sw3=0
         'loop unitl a switch is pushed
       loop
   EndEightxGainCal:
   inc SubMenuItem
return

BacktoMainMenu:
'Leases
'var2 used as a flag for exit
'pause 300 'allow time to get finger off button
  var2=255
  high intvcc,gainvcc 'turn of power to detector & 8x gain blockvar2=2
return

FindHalfRail:
'Leases
'var1 Used by called subroutine decimal contains sign in ASCII
'var3 Used by called subroutine decimal contains sign bit flag
'var4 - stores Pot setting
'var2 low RF threshold 50 (<-10dBm) for normal 120 (<-6dBM)for find half rail
'varw11 contains LoRf threshold 
'varw12 contains raw 8xgain block reading.
  varw11=120
  gosub ChkForLoRF 'Check AD8362 main output for at least -10dBm
  readadc10 7,varw12 'read 8xgain out
  'hi2cout [$7c],($80,$80,$40,"Raw ADC  8X Gain")
  'varw10=varw12
  'gosub decimal  
  'hi2cout [$7c],($80,$c1,$40,thousand,hundred,ten,unit," S")'s=searching 
  if varw12 <480 and var4>0 then
      dec var4
    else if varw12 >544 and var4<255 then
      inc var4
    else if varw12 >=480 and varw12 <=544 then
      goto EndFindHalfRail
  endif
  hi2cout [$5e],(var4) 'change pot
  goto FindHalfRail
EndFindHalfRail:
  'hi2cout [$7c],($80,$c5,$40,thousand,hundred,ten,unit)
return

ChkForLoRf: 'routine detects low RF and sticks until RF available for processing
'Leases
'varw11 low RF threshold 50 (<-10dBm) for normal 120 (<-6dBM)for find half rail
  readadc10 5,varw10 'read 8362 output
  if varw10<varw11 then 'Rf is less than threshold  
    gosub ClearDisplay
    hi2cout($80,$80,$40,"LO")
    hi2cout($80,$c0,$40,"RF")
    do while varw10<varw11 and Sw3=0
      readadc10 5,varw10 'read 8362 output
    loop
  endif
  if sw3=1 then
    pause 600 'allow some time to get finger off button
    goto mainmenu
  endif
return 



EEPROMCalDataUpdate:
#Rem
This subroutine displays the contents of all registers written during the
calibration procedure, Clock ATR Clock DTR, 0dBm value, Hi Power Scale Factor,
and Peaking Mode Scale Factor.  The user should also record this data in the 
table below in case the EEPROM data becomes corrupt and needs to be rewritten. 
All cal data is saved automatically during calibration but entries in the table 
below are the only written record of this data. ATR & DTR are saved as raw 
numbers not capacitance or ppm.
RECORD CAL VALUES IN THE TABLE BELOW. RENAME AND SAVE THIS PROGRAM USING THE 
'File' 'Save As...' MENU ITEMS AS YOUR DEFALUT SMARTLOAD CALIBRATION PROGRAM.

#endrem 
 
 '#######################################################################
 'RECORD CALIBRATION DATA FROM 'SHOW CAL DATA' SUBROUTINE IN THIS SECTION
 'ATR=12.50pf	'Analog Trimming Register - default 12.5pf
 'DTR=0ppm		'Digital Trimming Register - defalut +00ppm
 'ZerodBm=212	'Raw A-D value measured at 0.0dBm - defalut 211
 'Sf=792		'Scale factor to correct high power readings
 			'saved in register w25,b50,b51 - default 800
 'SfP=946		'SfP Scale factor to correct peaking readings
 			'saved in register w26,b52,b53 - defalut 950
 '#######################################################################
 
 #rem
 '#######################################################################
 'PROCEDURE TO RECOVER FROM CORRUPT EEPROM DATA WITHOUT RECALIBRATING

  	1) Restore the Clk Cal Freq data
  		Navigate to the Clk Cal Freq menu item 
  		Select the Analog Trim submenu item.
  		Use the Up Dn buttons to select the recorded ATR value
  		Press Sw3 to save the reading and exit the menu
  		Navigate to the 'Digital Trim' menu item and press Sw3 to enter. 
  		Use the Chg button to select the recorded DTR value
  		Press Sw3 to save the choice.
  	2)Restore the values for ZerodBm, Sf, and SfR.
  		Uncomment the ZerodBm, Sf, and SfP lines in the table above
  	3)Load this modified program into SmartLoad 
  		Connect the serial cable from this computer to SmartLoad.
  		Make sure that the Programming editor's Serial Port is working.
  		To do this"
  			In the Program Editor Select 'View' menu then 'Options...' 
  			Select the 'Serial Port' tab 
  			Make sure the radio button identifying the port is correct. 			otherwise select a port then push the 'Test Port' button and 			follow the insturctions.
  			using this editors 'PICAXE'menu item then selecting
  		From the Programming Editor menus select 'PICAXE' then 'Program...'
  		Wait for the 'Connecting to Hardware...' window. When it appears
  		push Sw3,the button below the display, and hold it unitl the program
  		download completes.
  	4)Navigate to the 'Show Cal Data' subroutine and run it. This will enter
  	  the values for 0dBm, Sf, and SpF into RAM.
  	5)Navigate to the 'Write EEPROM' subroutine
  	6)Select <-Yes Overwrite to save the three cal data entries and rewrite 	all other EEPROM data.
  DO NOT SAVE THIS MODIFIED PROGRAM. Just exit after downloading then download
  the SmartLoad application program to the unit.
  '###########################################################################
   #ENDREM
  
 gosub ClearDisplay
  gosub DisplayDn
 hi2cout ($80,$82,$40,"EEPROM CalData")
 SubMenuItem=0
 EEPROMCalDataUpdateInnerLoop:
 on SubMenuItem gosub ShowATR,ShowDTR,ShowZerodBm,ShowSf,ShowSfP
  pause 300 'wait a bit so display can be viewed if sw1 or 2 is held down  
  do while sw2=0 and sw3=0 'stay put until a switch is pushed
    'loop unitl a switch is pushed
  loop 'until a switch is pushed
  if sw3=1 then goto EndEEPROMCalDataUpdate
  inc SubMenuItem
  if SubMenuItem=5 then 
    submenuitem=0 
  endif
  goto EEPROMCalDAtaUpdateInnerLoop
  EndEEPROMCAlDataUpdate:
  inc MainMenuItem
return

ShowATR:
  gosub CapacitorCalc
return    

ShowDTR:
  gosub DisplayDTR
return 

ShowZerodBm:
  varw10=ZerodBm
  gosub decimal
  hi2cout ($80,$c4,$40,"0dBm=",hundred,ten,unit,"  ")
return 

ShowSf:
  varw10=Sf
  gosub decimal
  hi2cout ($80,$c4,$40,"Sf=",hundred,ten,unit,"  ")
return 
 
ShowSfP:
  varw10=SfP
  gosub decimal
  hi2cout ($80,$c4,$40,"SfP=",hundred,ten,unit)
return


WriteEEPROMData:'Writes EEPROM defaults to ISL2026 EEPROM.
#Rem
This subroutine writes EEPROM data. It does NOT write clock ATR & DTR these are witten during calibration directly to the ISL2026 Clock Control Register.
Other cal data, 0dBm,Sf,and SfP are read from their current locations in RAM and witten to EEPROM in the Housekeeping write section,
#EndRem
  gosub ClearDisplay 'ask if you're shure you want to rewrite defaults
  hi2cout ($80,$80,$40,$7f,"Get Out Of Here!")
  hi2cout ($80,$c0,$40,$7f,"Yes Overwrite")
  do while sw1=0 and sw2=0 and sw3=0 'stay put until a switch is pushed
    'loop unitl a switch is pushed
  loop 'until a switch is pushed
    if sw1=1 or sw3=1 then
      pause 600 'give a bit of time to get finger off of the select button
      goto EndWriteEEPROMData 'get out of here!
    endif
  gosub UnlockISL12016EEPROM:
  #Rem
  'START EEPROM PAGE WRITES HERE
  'Housekeeping items occupy the first page (16bytes)
  '############################################################################
  '0)TurnOffInterval defalut=255 disable interval (0-59 valid)
  '1&2)BacklightBrightness 1word default= 132,3 -900 about 2mA   
  '3)Measurement mode default 0 valid 0-full range,1-autorange 2-peaking -3datalog 
  '4-6) Atten off/on byte 4 word value valid 2-41.1dB in xx.x ie 107 is 10.7dB
  '7)Temp Alarm Threshold defalut 35degC
  '8)0dBm A-D count Update during cal, default is currently 213 
  '9-a)Sf. High Power scaling factor word update during cal defalut is currently 800 (.800)
  'b-c) SfP pealing gain scaling factor word update during cal default is 1000 (1.000) 
  'd)dBm/Watts display flag  e-f)Not used
  '############################################################################
  #EndRem
  'The next line contains houskeeping EEPROM data
  'byte                 0   1  2 3 4  5  6  7    8     9   a   b   c  d e f
  hi2cout [$ae],$0000,(255,132,3,0,0,100,0,35,ZerodBm,b50,b51,b52,b53,0,0,0)
  pause 25
  'dBm to Watts table 30 entries 32 bytes
  hi2cout $0010,(100,126,158,200,251,255,255,255,255,255,0,0,0,0,0,61)
  pause 25
  hi2cout $0020,(143,246,61,142,100,102,105,107,110,112,115,118,120,123,0,0)
  pause 25
  'CGRAM table 4 pages
  hi2cout $0030,($0e,$1f,$11,$11,$11,$11,$1f,$00,$00,$10,$10,$10,$10,$10,$10,$00)
  pause 25
  hi2cout $0040,($00,$18,$18,$18,$18,$18,$18,$00,$00,$1c,$1c,$1c,$1c,$1c,$1c,$00)
  pause 25
  hi2cout $0050,($00,$1e,$1e,$1e,$1e,$1e,$1e,$00,$01,$1f,$1f,$1f,$1f,$1f,$1f,$01)
  pause 25
  hi2cout $0060,($0e,$1f,$11,$11,$1f,$1f,$1f,$00,$0e,$1f,$1f,$1f,$1f,$1f,$1f,$00)
  pause 25
  'Backlight Table 3 pages
  'Data is stored serially starting at $0070. Each backlight value uses 3
  'bytes. The fist two bytes (word) are the PWM value xxx, the fourth is the LED 
  'current used in ma in the form xxx to be translted to xx.x for the
  'display when setting the backlight level. 
  '16 brightness and current values are saved. 
  'Note that the PWM pulse is inverted through the drive switch so high PWM
  'numbers represent low backlight levels. Cmd =pwmout bklite,248,xxx
  hi2cout $0070,(231,3,1,230,3,2,227,3,3,222,3,5,212,3,6,182)
  pause 25
  hi2cout $0080,(3,12,132,3,20,32,3,40,188,2,60,88,2,80,244,1)
  pause 25
  hi2cout $0090,(100,144,1,120,44,1,140,200,0,163,100,0,183,1,0,203)
  pause 25
  gosub LockISL12016EEPROM
  gosub ClearDisplay
  hi2cout ($80,$81,$40,"EEPROM Written")
  pause 1500
  EndWriteEEPROMData:
  gosub MainMenuLine1Title
  inc MainMenuItem 'goto next manin menu item on return. 
return

SplashScreen:
  hi2cout[$7c],($40," SmartLoad V0.3b")'cursor is at home pos so write first line
  hi2cout($80,$c2,$40,"Cal Routines")'cursor to start of 2nd line & write
  pause 1000 'leave some time to read the splash screen
return

ClearDisplay:
  hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display
  hi2cout ($80,$01) 'clear display
  pause 1
return
DisplayUpDn:'These three subroutines simplify Up and Dn writes to display
  hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display
  hi2cout ($80,$80,$40,"Up ") 'display up and down on display lines 1 & 2
  hi2cout ($80,$c0,$40,"Dn ")
return
'DisplayUp:
 ' hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display
 ' hi2cout ($80,$80,$40,"Up") 'display up and blank on display lines 1 & 2
 ' hi2cout ($80,$c0,$40,"  ")
'return
DisplayDn:
  hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display
  hi2cout ($80,$80,$40,"  ") 'display blank & down on display lines 1 & 2
  hi2cout ($80,$c0,$40,"Dn")
return    
    
decimal: 'parses varw10 either positive or negative no. & converts for display
  'Leases
  'var1 - contains sign in ASCII
  'varw10 - numeric power value to be written to dispaly
   if var3=1 then
    var1="-"
    else
    var1=" "
  endif 
  unit=varw10 dig 0 + "0"	'format for display by taking each digit to be displayed
  ten=varw10 dig 1 + "0"	'and placing it in a variable for use with the hi2cout command
  hundred=varw10 dig 2 + "0"
  thousand=varw10 dig 3 + "0" 
return  
 
'hex:						'convert binary character value to hex vlaue for ASCII display
' let LS_Nibble = b30 & %00001111
' let MS_Nibble = b30 & %11110000 / 16
' lookup LS_Nibble,("0123456789abcdef"),LS_Nibble
' lookup MS_Nibble,("0123456789abcdef"),MS_Nibble 
'return 

'WriteSpecialChars:	'writes CGRAM bargraph & battery characters
' hi2cout ($00,$38,$40)	'set instruction table lo to write CGRAM & set address
' hi2cout ($40,$0e,$1f,$11,$11,$11,$11,$1f,$00,$00,$10,$10,$10,$10,$10,$10,$00,$00,$18,$18,$18,$18,$18,$18,$00)
' hi2cout ($40,$00,$1c,$1c,$1c,$1c,$1c,$1c,$00,$00,$1e,$1e,$1e,$1e,$1e,$1e,$00,$01,$1f,$1f,$1f,$1f,$1f,$1f,$01)
' hi2cout ($40,$0e,$1f,$11,$11,$1f,$1f,$1f,$00,$0e,$1f,$1f,$1f,$1f,$1f,$1f,$00)
' hi2cout ($00,$39)	'set instruction table back to hi
'return 

WriteCCR:'enables ISL12026 CCR write
  hi2csetup i2cmaster,$de,i2cfast_8,i2cword 'Clock Register
  hi2cout [$de],$003f,($02) 'write 2 then 6 to config register to enable writes
  hi2cout [$de],$003f,($06)'Clock Control Register writes now enabled
return

UnlockISL12016EEPROM:
  gosub WriteCCR
  hi2cout $0010,(%00000000) 'unprotect all EEPROM blocks-should be default but... 
  pause 25 'Wait time for EEPROM wirte during this period I2C buss not available 
return

LockISL12016EEPROM: 'enable EEPROM block protection
  gosub WriteCCR
  hi2cout $0010,(%11100000) 'protect all EEProm blocks
  pause 25'Wait time for EEPROM wirte during this period I2C buss not available
return 

PwrOff:
  gosub ClearDisplay
  hi2cout ($80,$86,$40,"TTFN")
  'hi2cout ($80,$c6,$40,"Bye")
  pause 1000'wait a bit for the button to be released or unit will repower
  low shdn
  pause 1000
return
